# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:  # Round 1
        return "C"
    
    if len(my_history) == 9:  # Round 10
        return "D"
    
    # Check if opponent's code is simple (always C or always D)
    if "return \"C\"" in opponent_program_code or "return 'C'" in opponent_program_code:
        return "D"
    if "return \"D\"" in opponent_program_code or "return 'D'" in opponent_program_code:
        return "D"
    
    # Check if opponent defected repeatedly in early rounds (>=2 times in first 3 rounds)
    if len(opp_history) >= 3 and sum(1 for move in opp_history[:3] if move == "D") >= 2:
        return "D"
    
    # Tit-for-tat: mirror opponent's last move
    return opp_history[-1]